%------------------------------------------------------------------------------
% File     : SYO557^1 : TPTP v7.4.0. Released v5.2.0.
% Domain   : Syntactic
% Problem  : Exists on $i can be expressed in terms of choice on $
% Version  : Especial.
% English  :

% Refs     : [Bro11] Brown (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE29 [Bro11]

% Status   : Theorem
% Rating   : 0.43 v7.4.0, 0.22 v7.2.0, 0.12 v7.1.0, 0.25 v7.0.0, 0.14 v6.4.0, 0.17 v6.3.0, 0.20 v6.2.0, 0.43 v6.1.0, 0.29 v5.5.0, 0.50 v5.4.0, 0.80 v5.2.0
% Syntax   : Number of formulae    :    3 (   0 unit;   1 type;   0 defn)
%            Number of atoms       :   10 (   1 equality;   7 variable)
%            Maximal formula depth :    5 (   5 average)
%            Number of connectives :    7 (   0   ~;   0   |;   0   &;   5   @)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    5 (   5   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    3 (   1   :;   0   =)
%            Number of variables   :    4 (   0 sgn;   1   !;   1   ?;   2   ^)
%                                         (   4   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : Since P (eps P) is equivalent to exists x . P x, (^P.P(eps P)) = 
%            (^P.?? P). 
%          : Note that this problem uses ?? for exists instead of the ? 
%            quantifier.
%------------------------------------------------------------------------------
thf(eps,type,(
    eps: ( $i > $o ) > $i )).

thf(choiceax,axiom,(
    ! [P: $i > $o] :
      ( ? [X: $i] :
          ( P @ X )
     => ( P @ ( eps @ P ) ) ) )).

thf(conj,conjecture,
    ( ( ^ [P: $i > $o] :
          ( P @ ( eps @ P ) ) )
    = ( ^ [P: $i > $o] :
          ?? ( P ) ) )).

%------------------------------------------------------------------------------
